import Link from 'next/link';
import { Warehouse } from 'lucide-react';
import { RegisterForm } from '@/components/auth/register-form';
import { ThemeToggle } from '@/components/theme-toggle';

export default function RegisterPage() {
  return (
    <div className="flex min-h-screen flex-col">
      <div className="absolute top-4 right-4">
        <ThemeToggle />
      </div>
      <div className="flex flex-1 flex-col items-center justify-center p-8">
        <div className="mx-auto flex w-full max-w-sm flex-col justify-center space-y-6">
          <div className="flex flex-col items-center space-y-2 text-center">
            <Warehouse className="h-10 w-10 text-primary" />
            <h1 className="font-heading text-2xl font-bold">Create an Account</h1>
            <p className="text-muted-foreground">
              Enter your details to get started
            </p>
          </div>
          <RegisterForm />
          <p className="px-8 text-center text-sm text-muted-foreground">
            Already have an account?{' '}
            <Link
              href="/login"
              className="underline underline-offset-4 hover:text-primary"
            >
              Sign In
            </Link>
          </p>
        </div>
      </div>
    </div>
  );
}
